	output d:\assemble\sources.v45\hardsafe.2\hardsaf2.acx

OPT_GWVA_DEBUG_ERROR			; [option][root] generates an illegal when something goes wrong (for debugging purposes)
OPT_GWVA_DEBUG_PRINT_COMMENTS		; [option][root] print comments/warnings when assembling source

*OPT_GWVA_DEBUG_SEARCH_EXEC		; [option][root] is needed to do any log alert_box/logger
*OPT_GWVA_DEBUG_FILTER	 		; [var] filters debug messages to those in the list defined by OPT_GWVA_DEBUG_FILTER_PTR
*OPT_GWVA_DEBUG_FILTER_PTR		; [var] pointer to the list of the GWVA_OBJ_NAME of objects to debug (end with 0.l)
*OPT_GWVA_DEBUG_FILTER_0NAMES	 	; [option][root][OPT_GWVA_DEBUG_SEARCH_EXEC] filters debug messages for all objets having a 0.L in GWVA_OBJ_NAME
*OPT_GWVA_DEBUG_SEARCH_EXEC_IN_ALERT_BOX	; [option][root][LIB_HEXA][LIB_DECI][OPT_GWVA_DEBUG_SEARCH_EXEC] prints an alert box at each method distribution
*OPT_GWVA_DEBUG_SEARCH_EXEC_IN_LOGGER	; [option][root][LIB_HEXA][LIB_DECI][OPT_GWVA_DEBUG_SEARCH_EXEC][GWVA_DEBUG_MSG_MAX_SIZE][GWVA_DEBUG_MAX_MSG_DEBUG_PENDING] prints in log window each method distribution
*GWVA_DEBUG_MSG_MAX_SIZE = 256		; [var] defines the debug message max length (generated by SEARCH_EXEC)
*GWVA_DEBUG_MAX_MSG_DEBUG_PENDING = 64	; [var] how many debug messages can be sent in a row

OPT_FULL_PATHNAMES

	lea objet_application,a1

	include hardsaf2.def
	include visual45.s
	include hardsaf2.hs
	include hardsaf2.obj

	comment HEAD=7
	section TEXT

;---------------------------------------------------------------------------
	; Hard Disk Saver II
	; (c) Pierre LALOE 3 February 1996

	; en accessoire, supporte le VA_START

	; pass en V.A 4.5 le 03 XII 1998
;---------------------------------------------------------------------------

my_inits_created:
	bsr bton_active_changed	; charge la valeur du ressource

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

my_inits_opened:
	tst GWVA_ROOT_IS_ACC_PRG
	bne.s .cmd_line_pour_les_app

	bsr xhdi_inits		; teste XHDI et enregistre le timer si OK

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

.cmd_line_pour_les_app:
	tst d0
	beq.s .no_cmd_line

	cmp.l #'park',(a1)
	bne.s .pas_park

	bsr xhdi_inits		; teste XHDI et enregistre le timer si OK

	bsr park_all_disks		; oui !

	bra bton_close_clicked

.pas_park:

	cmp.l #'time',(a1)
	bne.s .pas_time
	lea 5(a1),a0
	clr.b d0
	bsr GWVA_DECI2VALUE
	cmp.l #999,d1
	bgt.s .bad_cmd_line
	cmp.l #10,d1
	blt.s .bad_cmd_line
	move.l d1,valeur_timer
	bra.s .cmd_line_ok

.pas_time:
.bad_cmd_line
	move #ALERT_BAD_CMD_LN,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX

.cmd_line_ok:
.no_cmd_line:

.no_cmd_park:

	move #FORM_MAIN,d0		; si ligne de cmd l'a chang
	move #TEXTE_TIMER,d1
	bsr GWVA_RSC_RETURN_PTR_ON_TEXT
	move.l valeur_timer,d0
	bsr GWVA_STOCK_DECI

	bsr xhdi_inits		; teste XHDI et enregistre le timer si OK

	cmp.w #GWVA_NO_ERROR_GENERIC,d7
	bne.s app_term

*****************

acc_open:	lea objet_fenetre_main,a0
	bsr GWVA_WIND_CREATE_OPEN_ONE_WIND

	cmp.w #GWVA_NO_ERROR_GENERIC,d7
	bne.s app_term

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

			*******

va_start_message:

	move.l bmsg_start_free_data(a1),a0

	tst.b (a0)
	beq.s .pas_va_start_si_ligne_cmd_vide	; magic !

	save.l a0
	bsr xhdi_inits		; teste XHDI et enregistre le timer si OK
	load.l a0

	cmp.l #'park',(a0)	; 'park'
	beq park_all_disks

	cmp.l #'time',(a0)	; 'time=54' 10<x<999
	bne.s .pas_time
	lea 5(a0),a0
	clr.b d0
	bsr GWVA_DECI2VALUE
	cmp.l #999,d1
	bgt.s .bad_cmd_line
	cmp.l #10,d1
	blt.s .bad_cmd_line
	move.l d1,valeur_timer

.pas_va_start_si_ligne_cmd_vide:
	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

.pas_time:
.bad_cmd_line:
	move #ALERT_BAD_CMD_LN,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX

	moveq #GWVA_PRGRET_CONSUMED,d6

	rts

*--------------------------------------------------------------------------*
bton_close_clicked:
	lea objet_fenetre_main,a0	; ne sert  rien pour l'APP
	bsr GWVA_WIND_DELETE_ONE_WIND	; mais c'est pas grave

app_term:
event_window_main_closed:
acc_close:

	bsr GWVA_ROOT_KILL_APPLICATION
	moveq #GWVA_PRGRET_CONSUMED,d6
	rts
	
*--------------------------------------------------------------------------*
bton_active_changed:

	move #FORM_MAIN,d0
	move #TEXTE_TIMER,d1
	bsr GWVA_RSC_RETURN_PTR_ON_TEXT
	move.l a1,a0
	clr.b d0
	bsr GWVA_DECI2VALUE
	move.l d1,valeur_timer

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

*--------------------------------------------------------------------------*
bton_park_now_clicked:
park_all_disks:

	tst.l XH_DRIVER_ROUTINE
	beq.s .no_park

	graf_mouse #BUSY_BEE

	clr d0			; XH_DEVICE_MAJOR

.do_park_all:
	save.w d0
	bsr stop_this_device
	load.w d0

	addq #1,d0
	cmp.w #8+8+2,d0
	bne.s .do_park_all

	graf_mouse #ARROW

.no_park:	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

*--------------------------------------------------------------------------*

event_window_app_timer:
	btst #SELECTED,struct_bton_active_timer+GWVA_FBTON_OBJ_STATE+1
	beq.s .no_check

	tst.l XH_DRIVER_ROUTINE
	beq.s .no_check2

	bsr check_and_park

.no_check:	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

.no_check2:	bsr XH_LOCATE_DRIVER

	cmp.w #GWVA_NO_ERROR_GENERIC,d7
	bne.s .never_come_back
	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

.never_come_back:
	lea objet_application,a0
	clr.l d0			; toutes le mthodes doivent dgager
	GWVA_CALL_METHOD_DIFF_METH_SAME_CLASS #GWVA_METHOD_UNREGISTER_TIMER

	moveq #GWVA_PRGRET_CONSUMED,d6
	rts

*--------------------------------------------------------------------------*

check_and_park:

	clr d0

.redo:	clr XH_DEVICE_MINOR
	move d0,XH_DEVICE_MAJOR
	save.w d0
	SUPEXEC XH_LAST_ACCESS
	load.w d0

	tst XH_RETURN_CODE
	bne.s .no_drive

	move.l XH_NB_MS,d2
	move.l valeur_timer,d1
	mulu.l #1000,d1
	cmp.l d1,d2
	blt.s .next

	save.w d0
	bsr stop_this_device
	load.w d0

.no_drive:
.next:	addq #1,d0
	cmp.w #8+8+2,d0
	bne.s .redo

	rts

*--------------------------------------------------------------------------*
stop_this_device:			; d0=device
	save.w d0

	clr.l XH_PRODUCTNAME
	clr.w XH_DEVICE_MINOR
	move.w d0,XH_DEVICE_MAJOR
	SUPEXEC XH_INQ_TARGET

	tst XH_RETURN_CODE
	bmi.s .do_not_exist

	btst #XH_TARGET_STOPPABLE,XH_DEVICE_FLAGS+3
	beq.s .cannot_be_stopped
	btst #XH_TARGET_STOPPED-16-8,XH_DEVICE_FLAGS
	bne.s .already_stopped

	btst #XH_TARGET_REMOVABLE,XH_DEVICE_FLAGS+3
	beq.s .medium_non_removable
	btst #SELECTED,struct_bton_park_removable+GWVA_FBTON_OBJ_STATE+1
	beq.s .do_not_park_removable
.medium_non_removable:

	load.w d0

	clr.w XH_DEVICE_MINOR
	clr.w XH_DEVICE_KEY
	move #1,XH_DO_STOP
	move.w d0,XH_DEVICE_MAJOR
	SUPEXEC XH_STOP
	rts

.do_not_park_removable:
.do_not_exist:
.cannot_be_stopped:
.already_stopped:
	load.w d0
	rts

*--------------------------------------------------------------------------*
xhdi_inits:
	tst.l XH_DRIVER_ROUTINE
	bne.s .already_initialised

	bsr XH_LOCATE_DRIVER

	cmp.w #GWVA_NO_ERROR_GENERIC,d7
	beq.s .xhdi_here

	move #ALERT_NO_XHDI,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX

	bra.s .error

.xhdi_here:	SUPEXEC XH_GET_VERSION

	cmp.w #$0125,XH_RETURN_CODE
	bge.s .good_version

	move #ALERT_BAD_VERSIO,d0
	move #1,d1
	bsr GWVA_RSC_ALERT_BOX

	bra.s .error

.good_version:
	lea objet_application,a0
	move.l #GWVA_METHOD_TIMER,d0
	move.l #10000,d1
	move.w #GWVA_ROOT_MASK_TIMER_REARM,d2
	GWVA_CALL_METHOD_DIFF_METH_SAME_CLASS #GWVA_METHOD_REGISTER_TIMER

.already_initialised:
	moveq #GWVA_NO_ERROR_GENERIC,d7
	rts

.error:	moveq #GWVA_ERROR_GENERIC,d7
	rts

*--------------------------------------------------------------------------*

	section BSS

valeur_timer:	ds.l 1	; parkage auto au bout de ... secondes

*--------------------------------------------------------------------------*

 END
